
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  crc8.c: functions to generate CRC for S/PDIF status word data
  Written by Nicholas Vinen, 2009-2013
*/

unsigned char crc8(unsigned char *data, unsigned short length) {
  unsigned char crc, bit;   
  crc = 0xFF;
  while( length ) {
    crc ^= data[0];
    for ( bit = 0 ; bit < 8; ++bit ) {
      if ( (crc&0x80) != 0 ) {
        crc <<= 1;
        crc ^= 0x1D;
      } else {
        crc <<= 1;
      }
    }
    ++data;
    --length;
  }
  return (~crc)&0xFF;
}
